/*
 THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF OUTRAGE
 ENTERTAINMENT, INC. ("OUTRAGE").  OUTRAGE, IN DISTRIBUTING THE CODE TO
 END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
 ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
 IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
 SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
 FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
 CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
 AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.
 COPYRIGHT 1996-2000 OUTRAGE ENTERTAINMENT, INC.  ALL RIGHTS RESERVED.
 */
 

#ifndef _VECMAT_H
#define _VECMAT_H

#include "pstypes.h"
#include "math.h"
#include "fix.h"

//what does this do?  Why didn't Jason put a comment here?
// Jason replies: This pragma disables the "possible loss of data" warning that
// is generated when converting doubles to floats
// A thousand pardons for the confusion

#pragma warning (disable:4244)

// All structs, defines and inline functions are located in vecmat_external.h
// vecmat_external.h is where anything that can be used by DLLs should be.
#include "vecmat_external.h"


extern const vector Zero_vector;
extern const matrix Identity_matrix;

// Used for debugging.  It is used in printf's so we do not have to write out the structure 3 times 
// to print all the coordinates.
#define XYZ(v) (v)->x,(v)->y,(v)->z

// Given a matrix, makes it an identity matrix
extern void vm_MakeIdentity (matrix *);

// Set a vector to {0,0,0}
extern void vm_MakeZero(vector *v);

// Set an angvec to {0,0,0}
extern void vm_MakeZero(angvec *a);

// Rotates a vector thru a matrix
extern void vm_MatrixMulVector (vector *,vector *,matrix *);

//Multiply a vector times the transpose of a matrix
void vm_VectorMulTMatrix(vector *result,vector *v,matrix *m);

// Multiplies 2 3x3 matrixes, returning the result in first argument
extern void vm_MatrixMul (matrix *,matrix *,matrix *);
 
//Multiply a matrix times the transpose of a matrix
void vm_MatrixMulTMatrix(matrix *dest,matrix *src0,matrix *src1);

// Computes all math look up tables, must be called before any vector stuff is used
extern void vm_InitMathTables();

// Given a vector, returns the magnitude.  Uses sqrt so it's slow
extern float vm_GetMagnitude (vector *);

// Given a vector, returns an approximation of the magnitude
extern float vm_GetMagnitudeFast (vector *);

// Returns the dot product of the two given vectors
extern float vm_DotProduct (vector *,vector *);

// Returns a perpendicular vector to the two given vectors
extern void vm_CrossProduct (vector *,vector *,vector *);

// Returns the difference between two vectors
extern void vm_SubVectors (vector *,const vector *,const vector *);

// Returns adds two vectors, returns result in first arg
extern void vm_AddVectors (vector *,vector *,vector *);

// Inits vector to 0,0,0
extern void vm_CenterVector (vector *);

// Given a vector, divides second arg by vector components
extern void vm_AverageVector (vector *,int);

// Normalizes a vector
// Returns the magnitude before normalization
extern float vm_NormalizeVector (vector *);

// Scales second arg vector by 3rd arg, placing result in first arg
extern void vm_ScaleVector (vector *,vector *,float);

// Scales all components of vector v by value s adds the result to p and stores result in vector d
extern void vm_ScaleAddVector (vector *d,vector *p,vector *v,float s);

// Divides second vector components by 3rd arg, placing result in first arg.  Useful for parametric lines
extern void vm_DivVector (vector *,vector *,float);

// Same as NormalizeVector, but uses approximation 
extern float vm_NormalizeVectorFast (vector *);

// Clears a matrix to zero
extern void vm_ClearMatrix (matrix *);

// Transposes a matrix in place
extern void vm_TransposeMatrix (matrix *);

// Given 3 angles (p,h,b), makes a rotation matrix out of them
extern void vm_AnglesToMatrix (matrix *,angle p,angle h,angle b);

//Ensure that a matrix is orthogonal
void vm_Orthogonalize(matrix *m);

//Compute a matrix from one or two vectors.  At least one and at most two vectors must/can be specified.
//Parameters:	m - filled in with the orienation matrix
//					fvec,uvec,rvec - pointers to vectors that determine the matrix.
//						One or two of these must be specified, with the other(s) set to NULL.
void vm_VectorToMatrix(matrix *m,vector *fvec,vector *uvec=NULL,vector *rvec=NULL);

//Computes a matrix from a vector and and angle of rotation around that vector
//Parameters:	m - filled in with the computed matrix
//					v - the forward vector of the new matrix
//					a - the angle of rotation around the forward vector
void vm_VectorAngleToMatrix(matrix *m,vector *v,angle a);

// Given an angle, places sin in 2nd arg, cos in 3rd.  Either can be null
extern void vm_SinCos (angle,float *,float *);

// Given x1,y1,x2,y2, returns the slope 
extern float vm_GetSlope (float,float,float,float);

//Calculates the perpendicular vector given three points
//Parms:	n - the computed perp vector (filled in)
//			v0,v1,v2 - three clockwise vertices
void vm_GetPerp(vector *n,vector *a,vector *b,vector *c);

//Calculates the (normalized) surface normal give three points
//Parms:	n - the computed surface normal (filled in)
//			v0,v1,v2 - three clockwise vertices
//Returns the magnitude of the normal before it was normalized.
//The bigger this value, the better the normal.
float vm_GetNormal(vector *n,vector *v0,vector *v1,vector *v2);

// Gets the distances (magnitude) between two vectors. Slow.
extern float vm_VectorDistance (const vector *a, const vector *b);

// Gets the approx distances (magnitude) between two vectors. Faster.
extern float vm_VectorDistanceQuick (vector *a,vector *b);

//Computes a normalized direction vector between two points
//Parameters:	dest - filled in with the normalized direction vector
//					start,end - the start and end points used to calculate the vector
//Returns:		the distance between the two input points
float vm_GetNormalizedDir (vector *dest,vector *end,vector *start);

// Returns a normalized direction vector between two points
// Uses sloppier magnitude, less precise
float vm_GetNormalizedDirFast (vector *dest,vector *end,vector *start);

//extract angles from a matrix 
angvec *vm_ExtractAnglesFromMatrix(angvec *a,matrix *m);

//	returns the angle between two vectors and a forward vector
angle vm_DeltaAngVec(vector *v0,vector *v1,vector *fvec);

//	returns the angle between two normalized vectors and a forward vector
angle vm_DeltaAngVecNorm(vector *v0,vector *v1,vector *fvec);

// Computes the distance from a point to a plane.
// Parms:	checkp - the point to check
// Parms:	norm - the (normalized) surface normal of the plane
//				planep - a point on the plane
// Returns:	The signed distance from the plane; negative dist is on the back of the plane
float vm_DistToPlane(vector *checkp,vector *norm,vector *planep);

//returns the value of a determinant
float calc_det_value(matrix *det);

void vm_MakeInverseMatrix (matrix *dest);
void vm_SinCosToMatrix(matrix *m,float sinp,float cosp,float sinb,float cosb,float sinh,float cosh);

// Gets the real center of a polygon
float vm_GetCentroid (vector *centroid,vector *src,int nv);

//	retrieves a random vector in values -RAND_MAX/2 to RAND_MAX/2
void vm_MakeRandomVector(vector *vec);

// Given a set of points, computes the minimum bounding sphere of those points
float vm_ComputeBoundingSphere(vector *center,vector *vecs,int num_verts);

// Gets the real center of a polygon, but uses fast magnitude calculation
// Returns the size of the passed in stuff
float vm_GetCentroidFast (vector *centroid,vector *src,int nv);

// Here are the C++ operator overloads -- they do as expected
extern matrix operator *(matrix src0, matrix src1);
extern matrix operator *=(matrix &src0, matrix src1);

#endif
