/*
 THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF OUTRAGE
 ENTERTAINMENT, INC. ("OUTRAGE").  OUTRAGE, IN DISTRIBUTING THE CODE TO
 END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
 ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
 IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
 SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
 FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
 CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
 AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.
 COPYRIGHT 1996-2000 OUTRAGE ENTERTAINMENT, INC.  ALL RIGHTS RESERVED.
 */
 
#ifndef __DDIO_FORCEFEEDBACK_H_
#define __DDIO_FORCEFEEDBACK_H_
#include "pstypes.h"
#include "string.h"
#define kMAX_Str			80
#define kInfinite_Duration	0xFFFFFF
#define FF_USEENVELOPE		0x01
#define HZ_to_uS(hz)		((int)(1000000.0/(double)(hz) + 0.5))
#define DDIO_FF_MAXEFFECTS	30
#if defined(WIN32)
//WINDOWS
#include "dinput.h"
#define FF_DEGREES			DI_DEGREES
#define FF_NOMINALMAX		DI_FFNOMINALMAX
#define FF_SECONDS			DI_SECONDS
#elif defined(__LINUX__) || defined(MACINTOSH)
//LINUX
#define FF_DEGREES			360		//fake value
#define FF_NOMINALMAX		10000	//fake value
#define FF_SECONDS			1000	//fake value
#endif
#define FORCEPROJECT	void *
typedef enum{
	kJoy1=0,
	kJoy2,
	kJoy3,
	kJoy4,
	kJoy5,
	kJoy6,
	kJoy7,
	kJoy8,
	kJoy9,
	kJoy10,
	kJoy11,
	kJoy12,
	kJoy13,
	kJoy14,
	kJoy15,
	kJoy16,
	kMaxJoy,
	kMouse,
	kKeyBoard,
	kAllDevices
}tDevice;
typedef enum{
	kNoButton=-1,
	kButton0=0,
	kButton1,
	kButton2,
	kButton3,
	kButton4,
	kButton5,
	kButton6,
	kButton7,
	kButton8,
	kButton9,
	kButton10,
	kButton31=31,
	kButtonMax
}tJoyButtons;
typedef enum{
	kStick  = 1<<0,
	kWheel  = 1<<1,
	kGamePad= 1<<2,
}tDeviceMask;
typedef struct{
	int 					ButtonMask;
	int						AxisMask;
	tDeviceMask				DevType;
	char					Name[kMAX_Str];
}tFFJoyInfo;
typedef enum{
	kDontPlayNow=0,
	kPlayNow,
	kPlayNowIfModified,
}tLoadEffect;
typedef enum {
	kConstant=0,
	kRamp,
	kCustom,
	kWave_Square,
	kWave_Sine,
	kWave_Triangle,
	kWave_SawUp,
	kWave_SawDown,
	kCondition_Spring,
	kCondition_Damper,
	kCondition_Inertia,
	kCondition_Friction,
	kMaxEffectSubTypes
}tEffType;
typedef struct tEffectConstant{
	long  Mag;					// +- 10,000
}tEffConstant;
typedef struct tEffectRamp{
   long  Start;					// +- 10,000
   long  End;					// +- 10,000
}tEffRamp;
typedef struct tEffectWave{
	unsigned long Mag;			// 0 to 10,000
	long  Offset;				// +- 10,000
	unsigned long Phase;		// 0 to 35,999
	unsigned long Period;		
}tEffWave;
typedef struct tEffectCondition{
	long  Offset;						// +- 10,000
	long  PositiveCoefficient;			// +- 10,000
	long  NegativeCoefficient;			// +- 10,000
	unsigned long PositiveSaturation;	// 0 to 10,000
	unsigned long NegativeSaturation;	// 0 to 10,000
	long  DeadBand;						// 0 to 10,000
}tEffCondition;
typedef struct tEffectCustom{
    int 	Channels;
    int	Period;
    int	Samples;
    long *ForceData;
}tEffCustom;
typedef union tEffectInfo{
   tEffConstant   Constant;
   tEffRamp       Ramp;
   tEffWave       Wave;
   tEffCondition  Condition;
   tEffCustom     Custom;
}tEffInfo;
typedef struct tEffectEnvelope{
	unsigned long AttackLevel; 
	unsigned long AttackTime; 
	unsigned long FadeLevel; 
	unsigned long FadeTime; 
}tEffEnvelope;
typedef enum{
	kXAxisOnly,
	kYAxisOnly,
	kBothAxes
}tEffAxis;
typedef struct tFFB_Effect{
	int					Flags;
	tEffType			Type;
	//tEffInfo			TypeInfo[2];
	tEffInfo			TypeInfo;
	unsigned long		Duration;
	unsigned long		Gain;				// 0-10000 -- scales all magnitudes and envelope
	unsigned long		Period;
	tEffAxis			Axis;
	tJoyButtons			Trigger;
	unsigned long		TriggerRepeatTime;
	long				Direction;			// 0 to 360 deg.
	tEffEnvelope		Envelope;
}tFFB_Effect;
extern bool ddForce_found;	//a Force Feedback device was found
extern bool ddForce_enabled;	//Force Feedback is ready and can be used
// ===================================================================
//									Function Prototypes
// ===================================================================
// -------------------------------------------------------------------
//	ddio_ff_AttachForce
//	Purpose:
//		Attaches variables initialized in the general ddio system to
//	the force feedback system.
// -------------------------------------------------------------------
void ddio_ff_AttachForce(void);
// -------------------------------------------------------------------
//	ddio_ff_DetachForce
//	Purpose:
//		Detaches variables used by the force-feedback system from the
//	ddio system
// -------------------------------------------------------------------
void ddio_ff_DetachForce(void);
// -------------------------------------------------------------------
// ddio_ff_Init
// Purpose:
//    Initialize force feedback if available.
// -------------------------------------------------------------------
int ddio_ff_Init(void);
// -------------------------------------------------------------------
// ddio_ffjoy_Init
// Purpose:
//    Creates and acquires all joysticks
//
// Input:
//    None
//
// Return:
//    # of sticks acquired
//
// Description:
//
// -------------------------------------------------------------------
int ddio_ffjoy_Init(void);
// -------------------------------------------------------------------
// ddio_ff_Acquire
// Purpose:
//    Acquires a direct input device for use.
//
// Input:
//    The device to acquire (use kDI_MaxJoy to acquire all available 
//    joysticks).
//
// Return:
//    # of devices acquired.
//
// Description:
//    Call this to gain access to a device after the device has been
//    created & after regaining the focus after losing it.
//
// -------------------------------------------------------------------
int ddio_ff_Acquire(tDevice dev);
// -------------------------------------------------------------------
// ddio_ff_Unacquire
// Purpose:
//    Unacquires a direct input device
//
// Input:
//    The device to unacquire (use kDI_MaxJoy to unacquire all available 
//    joysticks).
//
// Return:
//    # of devices unacquired.
//
// Description:
//    Call this to lose access to a device after the device has been
//    aquired
//
// -------------------------------------------------------------------
int ddio_ff_Unacquire(tDevice dev);
// -------------------------------------------------------------------
// ddio_ff_SetCoopLevel
// -------------------------------------------------------------------
static int ddio_ff_SetCoopLevel(tDevice dev, int coop_level);
// -------------------------------------------------------------------
// ddio_ffjoy_Query
// Purpose:
//    Besides checking what buttons/axis are available, this function
//    also checks for force feedback support.
// -------------------------------------------------------------------
int ddio_ffjoy_Query(int dev, int* but_flags, int* axis_flags);
/*
========================================================================
				Force Feedback Effect Functions
========================================================================
*/
// -------------------------------------------------------------------
//	ddio_ff_GetInfo
//	Purpose:
//		Returns information about the current state of the low-level
//	Force Feedback system.
// -------------------------------------------------------------------
void ddio_ff_GetInfo(bool *ff_found,bool *ff_enabled);
// -------------------------------------------------------------------
// ddio_ffb_Pause
// Purpose:
//    Pause the FFB output on the given device.  Use ddio_ffb_Continue to
//    continue where you left off.
// -------------------------------------------------------------------
void ddio_ffb_Pause(tDevice dev);
// -------------------------------------------------------------------
// ddio_ffb_Continue
// Purpose:
//    Unpause the FFB output on the given device.  Complimentary to
//    ddio_ffb_Pause.
// -------------------------------------------------------------------
void ddio_ffb_Continue(tDevice dev);
// -------------------------------------------------------------------
// ddio_ffb_Enable
// Purpose:
//    Must be called after initialization in order to activate the 
//    device.
//    Use ddio_ffb_Pause & ddio_ffb_Continue if you want disable forces
//    temporarily and resume later.
// -------------------------------------------------------------------
void ddio_ffb_Enable(tDevice dev);
// -------------------------------------------------------------------
// ddio_ffb_Disable
// Purpose:
//    Turns off FFB, but effects still play on processor.
// -------------------------------------------------------------------
void ddio_ffb_Disable(tDevice dev);
// -------------------------------------------------------------------
// ddio_ffb_effectCreate
// Purpose:
//    Create a single effect for future playback.
//    Effect is given a logical ID
// -------------------------------------------------------------------
int ddio_ffb_effectCreate(tDevice dev, tFFB_Effect* eff);
// -------------------------------------------------------------------
// ddio_ffb_DestroyAll
//	Purpose:
//		Destroys all created effects
// -------------------------------------------------------------------
void ddio_ffb_DestroyAll(void);
// -------------------------------------------------------------------
// ddio_ffb_effectPlay
// Purpose:
//    Play an effect that was previously created.
// -------------------------------------------------------------------
void ddio_ffb_effectPlay(short eID);
// -------------------------------------------------------------------
// ddio_ffb_effectStop
// Purpose:
//    Stop a single effect.
// -------------------------------------------------------------------
void ddio_ffb_effectStop(short eID);
// -------------------------------------------------------------------
// ddio_ffb_effectStopAll
// Purpose:
//    Stops all forces on the given device.
// -------------------------------------------------------------------
void ddio_ffb_effectStopAll(tDevice dev);
// -------------------------------------------------------------------
// ddio_ffb_effectUnload
// Purpose:
//    Unload a single effect...  Necessary to make room for other
//    effects.
// -------------------------------------------------------------------
void ddio_ffb_effectUnload(short eID);
// -------------------------------------------------------------------
// ddio_ffb_effectModify
// Purpose:
//    Modifies a single effect, only if the given parameters are
//    different from what's currently loaded.
// -------------------------------------------------------------------
void ddio_ffb_effectModify(short eID, int*	Direction, unsigned int* Duration, unsigned int* Gain, unsigned int* Period, tEffInfo* TypeInfo, tEffEnvelope* Envelope);
// -------------------------------------------------------------------
// ddio_ffb_GetEffectData
// Purpose:
//    Retrieves affect data for the given parameters, pass NULL for those you don't want
// -------------------------------------------------------------------
void ddio_ffb_GetEffectData(short eID, int*	Direction, unsigned int* Duration, unsigned int* Gain, unsigned int* Period, tEffInfo* TypeInfo, tEffEnvelope* Envelope);
// -------------------------------------------------------------------
// ddio_ffjoy_EnableAutoCenter
// Purpose:
//	Disables/Enables the autocentering of the joystick
// -------------------------------------------------------------------
void ddio_ffjoy_EnableAutoCenter(tDevice dev,bool enable);
// -------------------------------------------------------------------
// ddio_ffjoy_SetGain
// Purpose:
//	Sets the gain for joystick, pass a value of 0-1
// -------------------------------------------------------------------
void ddio_ffjoy_SetGain(tDevice dev,float value);
// -------------------------------------------------------------------
// ddio_ffjoy_IsAutoCentered
// Purpose:
//	Returns true if the joystick is set for autocentering
// -------------------------------------------------------------------
bool ddio_ffjoy_IsAutoCentered(tDevice dev);
// -------------------------------------------------------------------
// ddio_ffjoy_SupportAutoCenter
// Purpose:
//	Returns true if the FF joystick supports auto centering
// -------------------------------------------------------------------
bool ddio_ffjoy_SupportAutoCenter(tDevice dev);
/*
===========================================================================
			Private Functions
===========================================================================
*/
#if defined(WIN32)
// -------------------------------------------------------------------
// ddio_ffjoy_AcquireErr
// Purpose:
//    Handle success/err reporting
// -------------------------------------------------------------------
static int ddio_ffjoy_AcquireErr(HRESULT res, int dev_num);
// -------------------------------------------------------------------
// FFEnumCallback
// Purpose:
//    Initialize all connected joysticks.
//
// Input:
//    pdinst   info about the current joystick being enumed.
//    pvRef    the direct input object that was passed in before
//             starting the enum process.
// Return:
//   DIENUM_CONTINUE    continue calling us with any more devices
//   DIENUM_STOP        all done, don't call us back anymore, go away.
// -------------------------------------------------------------------
BOOL CALLBACK FFEnumCallback(LPCDIDEVICEINSTANCE pdinst, LPVOID pvRef);
#endif
//	Given a filename resource, this loads the file and creates a resource
//	for it.  It returns a handle to that resource.
//	If it returns NULL, then it couldn't load the project.
//	Make sure device is aquired before calling.
FORCEPROJECT ddio_ForceLoadProject(char *filename,tDevice dev);
//	Unloads a FORCEPROJECT file
void ddio_ForceUnloadProject(FORCEPROJECT prj);
//	Given a handle to a resource, and the name of the effect to load
//	it will load that effect.  Returns the effect ID, or -1 if it couldn't
//	be created
int ddio_CreateForceFromProject(FORCEPROJECT project,char *forcename);
#endif