/*
 THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE PROPERTY OF OUTRAGE
 ENTERTAINMENT, INC. ("OUTRAGE").  OUTRAGE, IN DISTRIBUTING THE CODE TO
 END-USERS, AND SUBJECT TO ALL OF THE TERMS AND CONDITIONS HEREIN, GRANTS A
 ROYALTY-FREE, PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY SUCH END-USERS
 IN USING, DISPLAYING,  AND CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
 SUCH USE, DISPLAY OR CREATION IS FOR NON-COMMERCIAL, ROYALTY OR REVENUE
 FREE PURPOSES.  IN NO EVENT SHALL THE END-USER USE THE COMPUTER CODE
 CONTAINED HEREIN FOR REVENUE-BEARING PURPOSES.  THE END-USER UNDERSTANDS
 AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE SAME BY USE OF THIS FILE.
 COPYRIGHT 1996-2000 OUTRAGE ENTERTAINMENT, INC.  ALL RIGHTS RESERVED.
 */
 

#ifndef _3D_H
#define _3D_H

#include "pstypes.h"
#include "vecmat.h"		//the vector/matrix library
#include "grdefs.h"
#include "float.h"

extern int g3d_interp_outline;		//if on, polygon models outlined in white

extern vector Matrix_scale;		//how the matrix is currently scaled

//Structure for storing u,v,light values.  This structure doesn't have a
//prefix because it was defined somewhere else before it was moved here
typedef struct g3UVL {
	float	u,v;			//texture coordinates
	float u2,v2;
	
	union{
		float	l;				//intensity lighting
		float   r;
	};
	float g,b,a;		//rgba lighting
} g3UVL;

//Stucture to store clipping codes in a word
typedef struct g3Codes {
	ubyte cc_or,cc_and;
} g3Codes;

//flags for point structure
#define PF_PROJECTED 	1	//has been projected, so sx,sy valid
#define PF_FAR_ALPHA		2	//past fog zone
#define PF_TEMP_POINT	4	//created during clip
#define PF_UV				8	//has uv values set
#define PF_L				16	//has lighting values set
#define PF_RGBA			32	//has RGBA lighting values set
#define PF_UV2				64 // has lightmap uvs as well


//clipping codes flags

#define CC_OFF_LEFT	1
#define CC_OFF_RIGHT	2
#define CC_OFF_BOT	4
#define CC_OFF_TOP	8
#define CC_OFF_FAR	16
#define CC_OFF_CUSTOM	32
#define CC_BEHIND		128

//Used to store rotated points for mines.  Has frame count to indictate
//if rotated, and flag to indicate if projected.
typedef struct g3Point {
	float		p3_sx,p3_sy;		//screen x&y
	ubyte		p3_codes;			//clipping codes
	ubyte		p3_flags;			//projected?
	short		p3_pad;				//keep structure longword aligned
	vector		p3_vec;				//x,y,z of rotated point
	g3UVL		p3_uvl;				//uv & lighting values
} g3Point;

//macros to reference x,y,z elements of a 3d point
#define p3_x p3_vec.x
#define p3_y p3_vec.y
#define p3_z p3_vec.z

//macros to reference individual elements of the uvls struct
#define p3_u p3_uvl.u
#define p3_v p3_uvl.v
#define p3_l p3_uvl.l
#define p3_r p3_uvl.r
#define p3_g p3_uvl.g
#define p3_b p3_uvl.b
#define p3_a p3_uvl.a
#define p3_u2 p3_uvl.u2
#define p3_v2 p3_uvl.v2

//Functions in library

//3d system startup and shutdown:

//initialize the 3d system
void g3_Init(void);

//close down the 3d system
void g3_Close(void);


//Frame setup functions:

//start the frame, specifying view position, matrix, & zoom
void g3_StartFrame(vector *view_pos,matrix *view_matrix,float zoom);

//end the frame
void g3_EndFrame(void);

//get the current view position
void g3_GetViewPosition(vector *vp);

//	returns the current view matrix
void g3_GetViewMatrix(matrix *mat);

//	returns the current unscaled view matrix
void g3_GetUnscaledMatrix(matrix *mat);


//Instancing

//instance at specified point with specified orientation
void g3_StartInstanceMatrix(vector *pos,matrix *orient);

//instance at specified point with specified orientation
void g3_StartInstanceAngles(vector *pos,angvec *angles);

//pops the old context
void g3_DoneInstance();

//Misc utility functions:

//get current field of view.  Fills in angle for x & y
void g3_GetFOV(float *fov_x,float *fov_y);

//get zoom.  For a given window size, return the zoom which will achieve
//the given FOV along the given axis.
float g3_GetZoom(char axis,float fov,short window_width,short window_height);

//returns the normalized, unscaled view vectors
void g3_GetViewVectors(vector *forward,vector *up,vector *right);

//returns true if a plane is facing the viewer. takes the unrotated surface 
//normal of the plane, and a point on it.  The normal need not be normalized
bool g3_CheckNormalFacing(vector *v,vector *norm);

//Point definition and rotation functions:

//returns codes_and & codes_or of a list of points numbers
g3Codes g3_CheckCodes(int nv,g3Point **pointlist);

//rotates a point. returns codes.  does not check if already rotated
ubyte g3_RotatePoint(g3Point *dest,vector *src);

//projects a point
void g3_ProjectPoint(g3Point *point);

//calculate the depth of a point - returns the z coord of the rotated point
float g3_CalcPointDepth(vector *pnt);

//from a 2d point, compute the vector through that point
void g3_Point2Vec(vector *v,short sx,short sy);

//code a point.  fills in the p3_codes field of the point, and returns the codes
ubyte g3_CodePoint(g3Point *point);

//delta rotation functions
vector *g3_RotateDeltaX(vector *dest,float dx);
vector *g3_RotateDeltaY(vector *dest,float dy);
vector *g3_RotateDeltaZ(vector *dest,float dz);
vector *g3_RotateDeltaVec(vector *dest,vector *src);
ubyte g3_AddDeltaVec(g3Point *dest,g3Point *src,vector *deltav);

//Drawing functions:
//draw a polygon
//Parameters:	nv - the number of verts in the poly
//					pointlist - a pointer to a list of pointers to points
//					bm - the bitmap handle if texturing.  ignored if flat shading
int g3_DrawPoly(int nv,g3Point **pointlist,int bm,int map_type=0,g3Codes *clip_codes=NULL);

//draw a sortof sphere - i.e., the 2d radius is proportional to the 3d
//radius, but not to the distance from the eye
void g3_DrawSphere(ddgr_color color,g3Point *pnt,float rad);

//like g3_DrawPoly(), but checks to see if facing.  If surface normal is
//NULL, this routine must compute it, which will be slow.  It is better to 
//pre-compute the normal, and pass it to this function.  When the normal
//is passed, this function works like g3_CheckNormalFacing() plus
//g3_DrawPoly().
void g3_CheckAndDrawPoly(int nv,g3Point **pointlist,int bm,vector *norm,vector *pnt);

//draws a line. takes two points.
void g3_DrawLine(ddgr_color color,g3Point *p0,g3Point *p1);

//draws a bitmap with the specified 3d width & height 
//returns 1 if off screen, 0 if drew
void g3_DrawBitmap(vector *pos,float width,float height,int bm,int color=-1);

// Draws a bitmap that has been rotated about its center.  Angle of rotation is passed as 'rot_angle'
void g3_DrawRotatedBitmap (vector *pos,angle rot_angle,float width,float height,int bm,int color=-1);

//specifies 2d drawing routines to use instead of defaults.  Passing
//NULL for either or both restores defaults
void g3_SetSpecialRender(void (*tmap_drawer)(),void (*flat_drawer)(),int (*line_drawer)());

//Object functions:

//init code for bitmap models
void g3_InitPolygonModel(void *model_ptr);

//un-initialize, i.e., convert color entries back to RGB15
void g3_UninitPolygonModel(void *model_ptr);

//alternate interpreter for morphing object
void g3_DrawMorphingModel(void *model_ptr,int *model_bitmaps,angvec *anim_angles,float light,vector *new_points);

//this remaps the 15bpp colors for the models into a new palette.  It should
//be called whenever the palette changes
void g3_RemapInterpColors(void);

//Draw a wireframe box aligned with the screen.  Used for the editor.
//Parameters:	color - the color to draw the lines
//					pnt - the center point
//					rad - specifies the width/2 & height/2 of the box
void g3_DrawBox(ddgr_color color,g3Point *pnt,float rad);

// Sets up a custom clipping plane - g3_StartFrame must be called before this is called
void g3_SetCustomClipPlane (ubyte state,vector *pnt,vector *normal);

// sets the z distance of the far clipping plane
void g3_SetFarClipZ (float z);

//Disables the far clip plane
inline void g3_ResetFarClipZ()
{
	g3_SetFarClipZ(FLT_MAX);
}

//Clips a polygon
//Parameters:	pointlist - pointer to a list of pointers to points
//					nv - the number of points in the polygon
//					cc - the clip codes for this polygon
//Returns:	a pointer to a list of pointer of points in the clipped polygon
//NOTE: You MUST call g3_FreeTempPoints() when you're done with the clipped polygon
g3Point **g3_ClipPolygon(g3Point **pointlist,int *nv,g3Codes *cc);

//Free up any temp points (created by the clipper) in the given pointlist
//Parameters:	pointlist - pointer to list of pointers to points, returned by g3_ClipPolygon()
//					nv - the number of points in pointlist
void g3_FreeTempPoints(g3Point **pointlist,int nv);

// Gets the matrix scale vector
void g3_GetMatrixScale	(vector *matrix_scale);

// Sets the triangulation test to on or off
void g3_SetTriangulationTest (int state);

//draws a line based on the current setting of render states. takes two points.  returns true if drew
void g3_DrawSpecialLine(g3Point *p0,g3Point *p1);

// Draws a bitmap on a specific plane.  Also does rotation.  Angle of rotation is passed as 'rot_angle'
void g3_DrawPlanarRotatedBitmap (vector *pos,vector *norm,angle rot_angle,float width,float height,int bm);

#endif

