/*
=========================================================
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE 
PROPERTY OF OUTRAGE ENTERTAINMENT, INC. 
('OUTRAGE').  OUTRAGE, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND 
CONDITIONS HEREIN, GRANTS A ROYALTY-FREE, 
PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY 
SUCH END-USERS IN USING, DISPLAYING,  AND 
CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-
COMMERCIAL, ROYALTY OR REVENUE FREE PURPOSES. 
IN NO EVENT SHALL THE END-USER USE THE 
COMPUTER CODE CONTAINED HEREIN FOR REVENUE-
BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE 
SAME BY USE OF THIS FILE.
COPYRIGHT 1999 OUTRAGE ENTERTAINMENT, INC.  ALL 
RIGHTS RESERVED.
=========================================================
*/

/*
* $Logfile: /DescentIII/Main/entropy/EntropyPackets.cpp $
* $Revision: 10 $
* $Date: 5/21/99 10:03a $
* $Author: Jeff $
*
* <insert description of file here>
*
* $Log: /DescentIII/Main/entropy/EntropyPackets.cpp $
 * 
 * 10    5/21/99 10:03a Jeff
 * hopefully filled in any remaining gaps related to have more than you
 * can carry virus loads
 * 
 * 9     5/12/99 11:04p Jeff
 * dmfc and multiplayer games now have endian friendly packets (*whew*)
 * 
 * 8     5/12/99 11:28a Jeff
 * added sourcesafe comment block
*
* $NoKeywords: $
*/



#include "gamedll_header.h"
#include <string.h>
#include "idmfc.h"
#include "Entropystr.h"
#include "EntropyAux.h"

// declared in EntropyBase.cpp
extern IDMFC *DMFCBase;
extern room *dRooms;
extern object *dObjects;

// Server only
// Sends a room takeover packet to all the clients
void SendTakeOverPacket(int newteam,int oldteam,int room,int victor)
{
	// declare our packet variables
	int count = 0;
	ubyte data[MAX_GAME_DATA_SIZE];

	// start a SPID_TAKEOVER packet
	DMFCBase->StartPacket(data,SPID_TAKEOVER,&count);
	
	// add the data
	MultiAddByte(victor,data,&count);
	MultiAddByte(oldteam,data,&count);	
	MultiAddByte(newteam,data,&count);		
	MultiAddInt(room,data,&count);

	// send the packet to all
	DMFCBase->SendPacket(data,count,SP_ALL);
}

// Client only
// receiver for a room takeover packet.
void ReceiveTakeOverPacket(ubyte *data)
{
	ubyte newteam,oldteam;
	int room;
	int count = 0;
	int victor;
	
	//unpack our data
	victor = MultiGetByte(data,&count);
	oldteam = MultiGetByte(data,&count);
	newteam = MultiGetByte(data,&count);	
	room = MultiGetInt(data,&count);

	// do the actual processesing
	TakeOverRoom(newteam,oldteam,room,victor);
}

void RemoveVirusFromPlayer(int player_num,bool remove_all);

// client only
// receiver function for when a client receives game join data
void GetGameStartPacket(ubyte *data)
{
	int i,count = 0;

	for(i=0;i<NUM_TEAMS;i++)
	{
		TeamScore[i] = MultiGetInt(data,&count);
	}

	for(i=0;i<DLLMAX_PLAYERS;i++)
	{
		if(MultiGetByte(data,&count))
		{			
			int num_virus = MultiGetInt(data,&count);
			int v_count;
			RemoveVirusFromPlayer(i,true);

			for(v_count=0;v_count<num_virus;v_count++)
			{
				DLLInvAddTypeID(i,OBJ_POWERUP,virus_id,-1,-1,0,TXT_VIRUS);
			}

			NumberOfKillsSinceLastDeath[i] = MultiGetInt(data,&count);
		}
	}
}

//server only
//send game join data
void SendGameStartPacket(int pnum)
{
	int count = 0;
	int i;

	ubyte data[MAX_GAME_DATA_SIZE];
	DMFCBase->StartPacket(data,SPID_NEWPLAYER,&count);

	for(i=0;i<NUM_TEAMS;i++)
	{
		MultiAddInt(TeamScore[i],data,&count);
	}

	for(i=0;i<DLLMAX_PLAYERS;i++)
	{
		if(DMFCBase->CheckPlayerNum(i))
		{
			MultiAddByte(1,data,&count);
			MultiAddInt(DLLInvGetTypeIDCount(i,OBJ_POWERUP,virus_id),data,&count);
			MultiAddInt(NumberOfKillsSinceLastDeath[i],data,&count);			
		}else
		{
			MultiAddByte(0,data,&count);
		}
	}


	DMFCBase->SendPacket(data,count,pnum);

	//send over the rest
	SendRoomInfo(pnum);
}

// server only
// tells the clients that a virus has been picked up
// it will also process the pickup for the server
void SendClientPickupVirus(int player_num)
{
	int start,count = 0;
	ubyte data[MAX_GAME_DATA_SIZE];
	DMFCBase->StartPacket(data,SPID_PICKUPVIRUS,&count);
	start = count;

	MultiAddByte(player_num,data,&count);
	// process the packet ourselves (notice we're using start to reference
	// to the beginning of the packet data)
	ReceivePickupVirus(&data[start]);

	// send to all the clients
	DMFCBase->SendPacket(data,count,SP_ALL);
}

// processes a pickup packet
void ReceivePickupVirus(ubyte *data)
{
	int player_num,count = 0;
	player_num = MultiGetByte(data,&count);
	
	// add the virus to the player's inventory
	DLLInvAddTypeID(player_num,OBJ_POWERUP,virus_id,-1,-1,0,TXT_VIRUS);

	if(player_num==DMFCBase->GetPlayerNum())
	{
		// if it is us, inform them with a HUD message
		DLLAddHUDMessage(TXT_PICKUPVIRUS);
	}
}

#define RT_REDLAB	0
#define RT_REDREP	1
#define RT_REDENG	2
#define RT_BLULAB	3
#define RT_BLUREP	4
#define RT_BLUENG	5

// Server only
// sends the current state of the special rooms (since room ownership can
// change before a client joins the game)
void SendRoomInfo(int pnum)
{ 
	char *room_info;
	int flags,r,i;
	room_info = (char *)malloc(sizeof(char)*RoomCount);
	if(!room_info)
		return;

	for(r=0;r<RoomCount;r++){
		flags = dRooms[RoomList[r]].flags;

		if(flags&RF_SPECIAL1){
			room_info[r] = RT_REDLAB;
		}
		if(flags&RF_SPECIAL2){
			room_info[r] = RT_REDENG;
		}
		if(flags&RF_SPECIAL3){
			room_info[r] = RT_REDREP;
		}
		if(flags&RF_SPECIAL4){
			room_info[r] = RT_BLULAB;
		}
		if(flags&RF_SPECIAL5){
			room_info[r] = RT_BLUENG;
		}
		if(flags&RF_SPECIAL6){
			room_info[r] = RT_BLUREP;
		}
	}

	int count = 0;

	ubyte data[MAX_GAME_DATA_SIZE];
	DMFCBase->StartPacket(data,SPID_ROOMINFO,&count);

	for(i=0;i<NUM_TEAMS;i++)
	{
		MultiAddInt(TeamOwnedRooms[i],data,&count);
	}	

	for(i=0;i<RoomCount;i++)
	{
		MultiAddByte(room_info[i],data,&count);
	}

	DMFCBase->SendPacket(data,count,pnum);

	free(room_info);
}

// client only
// receives room info packet from the server to update special room ownership
void ReceiveRoomInfo(ubyte *data)
{
	int i,count = 0;
	int flag;
	char *room_info;
	room_info = (char *)malloc(sizeof(char)*RoomCount);
	if(!room_info){
		FatalError("Out of Memory");
		return;
	}

	for(i=0;i<NUM_TEAMS;i++)
	{
		TeamOwnedRooms[i] = MultiGetInt(data,&count);
	}

	for(i=0;i<RoomCount;i++)
	{
		room_info[i] = MultiGetByte(data,&count);

		switch(room_info[i]){
		case RT_REDLAB:
			flag = RF_SPECIAL1;
			PaintRoomWithTexture(LabText[RED_TEAM],RoomList[i]);
			break;
		case RT_REDENG:
			flag = RF_SPECIAL2;
			PaintRoomWithTexture(EnergyText[RED_TEAM],RoomList[i]);
			break;
		case RT_REDREP:
			flag = RF_SPECIAL3;
			PaintRoomWithTexture(RepairText[RED_TEAM],RoomList[i]);
			break;
		case RT_BLULAB:
			flag = RF_SPECIAL4;
			PaintRoomWithTexture(LabText[BLUE_TEAM],RoomList[i]);
			break;
		case RT_BLUENG:
			flag = RF_SPECIAL5;
			PaintRoomWithTexture(EnergyText[BLUE_TEAM],RoomList[i]);
			break;
		case RT_BLUREP:
			flag = RF_SPECIAL6;
			PaintRoomWithTexture(RepairText[BLUE_TEAM],RoomList[i]);
			break;
		default:
			flag = 0;
		}
		room *rp = &dRooms[RoomList[i]];
		rp->flags &= ~RF_SPECIAL1;
		rp->flags &= ~RF_SPECIAL2;
		rp->flags &= ~RF_SPECIAL3;
		rp->flags &= ~RF_SPECIAL4;
		rp->flags &= ~RF_SPECIAL5;
		rp->flags &= ~RF_SPECIAL6;
		rp->flags |= flag;
		rp->room_change_flags |= RCF_GOALSPECIAL_FLAGS;
	}
	free(room_info);
}

// server only
// tell the clients that a virus has been created
void SendVirusCreate(object *obj)
{
	int start,count = 0;

	ubyte data[MAX_GAME_DATA_SIZE];
	DMFCBase->StartPacket(data,SPID_VIRUSCREATE,&count);
	start = count;

	int objnum = obj-dObjects;
	MultiAddInt(objnum,data,&count);

	// process this packet ourselves
	DoVirusCreate(&data[start]);

	// tell all the clients
	DMFCBase->SendPacket(data,count,SP_ALL);	
}

// process a new virus being created packet
void DoVirusCreate(ubyte *data)
{
	int s_objnum,l_objnum,count=0;

	s_objnum = MultiGetInt(data,&count);

	l_objnum = DMFCBase->ConvertServerToLocalObjnum(s_objnum);

	if(l_objnum!=-1)
	{
		// create some nice special fx for the spawning virus
		DLLCreateRandomSparks(rand()%150+100,&dObjects[l_objnum].pos,dObjects[l_objnum].roomnum,HOT_SPARK_INDEX,(rand()%3)+2);
	}
}