/*
=========================================================
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE 
PROPERTY OF OUTRAGE ENTERTAINMENT, INC. 
('OUTRAGE').  OUTRAGE, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND 
CONDITIONS HEREIN, GRANTS A ROYALTY-FREE, 
PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY 
SUCH END-USERS IN USING, DISPLAYING,  AND 
CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-
COMMERCIAL, ROYALTY OR REVENUE FREE PURPOSES. 
IN NO EVENT SHALL THE END-USER USE THE 
COMPUTER CODE CONTAINED HEREIN FOR REVENUE-
BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE 
SAME BY USE OF THIS FILE.
COPYRIGHT 1999 OUTRAGE ENTERTAINMENT, INC.  ALL 
RIGHTS RESERVED.
=========================================================
*/

/*
 * Header for weapon.cpp & weaponfire.cpp
 *
 * 
 */

#ifndef WEAPON_H
#define WEAPON_H

#include "pstypes.h"
#include "object.h"
#include "objinfo.h"
#include "weapon_external.h"

#define MAX_PRIMARY_WEAPONS	10
#define MAX_SECONDARY_WEAPONS	10

#define MAX_WEAPON_NOT_HIT_PARENT_TIME	3.0f

// This can be changed safely
#define MAX_WEAPONS	200

//	THIS CONSTANT SHOULD EQUAL THE NUMBER OF WEAPONS SELECTABLE!!!
#define MAX_STATIC_WEAPONS	21

#define DEFAULT_WEAPON_SIZE	1.0  // Default size of a weapon -- used for bitmap weapons

#define HAS_FLAG(a)	(1<<(a))

// Weapon flags
#define WF_HUD_ANIMATED		(1<<0)
#define WF_IMAGE_BITMAP		(1<<1)	// whether or not the firing image is a bitmap or model
#define WF_SMOKE				(1<<2)	// Weapon drops smoke as it moves
#define WF_MATTER_WEAPON	(1<<3)	// This a matter weapon, as opposed to an energy weapon
#define WF_ELECTRICAL		(1<<4)	// This weapons fires as an electrical storm
#define WF_IMAGE_VCLIP		(1<<5)	// This weapon fire image is a vclip
#define WF_SPRAY				(1<<6)	// This weapon is a spray, like a flamethrower
#define WF_STREAMER			(1<<7)	// This weapon has a streamer effect attached
#define WF_INVISIBLE			(1<<8)	// This weapon is invisible
#define WF_RING				(1<<9)	// This weapon is drawn ring style
#define WF_SATURATE			(1<<10)	// Saturate this bitmap weapon
#define WF_BLAST_RING		(1<<11)	// Creates a blast ring upon explosion
#define WF_PLANAR_BLAST		(1<<12)	// Blast bitmap takes on the walls plane
#define WF_PLANAR				(1<<13)	// This weapon doesn't always face you
#define WF_ENABLE_CAMERA	(1<<14)	// This weapon can be used for missile camera
#define WF_SPAWNS_IMPACT	(1<<15)	// This weapon spawns others on impact
#define WF_SPAWNS_TIMEOUT	(1<<16)	// This weapon spawns others when it times out
#define WF_EXPAND				(1<<17)	// This weapon expands when exploding
#define WF_MUZZLE				(1<<18)	// This weapon produces a muzzle flash when fired
#define WF_MICROWAVE			(1<<19)	// This weapon makes a microwave effect on the victim
#define WF_NAPALM				(1<<20)	// This weapon does a napalm effect to objects it touches
#define WF_REVERSE_SMOKE	(1<<21)	// The smoke trail gets smaller as it ages
#define WF_GRAVITY_FIELD	(1<<22)	// This weapon has a gravity field 
#define WF_COUNTERMEASURE	(1<<23)	// This weapon is a countermeasure
#define WF_SPAWNS_ROBOT		(1<<24)	// This weapon spawns a robot upon death
#define WF_FREEZE				(1<<25)	// This weapon slows a ship/object down
#define WF_TIMEOUT_WALL			(1<<26)	// This weapon times out like a wall hit
#define WF_PLANAR_SMOKE		(1<<27)	// This weapon has a planar smoke trail instead of a blob
#define WF_SILENT_HOMING	(1<<28)	// This weapon does not give a homing lock sound
#define WF_HOMING_SPLIT		(1<<29)	// This weapon homes when it splits
#define WF_NO_ROTATE			(1<<30)	// This weapon does not rotate as a bitmap
#define WF_CUSTOM_SIZE		(1<<31)  // This weapon uses a custom size

#define MAX_LASER_LEVEL			4
#define MAX_SUPER_LASER_LEVEL	6

#define	PRIMARY_INDEX				0
#define	SECONDARY_INDEX			10

// These defines must correspond to the Static_weapons_names array

#define MAX_WEAPON_SOUNDS		7
#define WSI_FIRE					0 // chrishack -- removed!  Change const when we add a new slot
										  // grep for occurances of WSI_FIRE and fix (or remove) old code
#define WSI_IMPACT_WALL			1
#define WSI_FLYING				2
#define WSI_IMPACT_ROBOT		3
#define WSI_BOUNCE				4

typedef struct
{
	char name[PAGENAME_LEN];
	float player_damage;				// how much damage a full impact causes a player
	float generic_damage;				// how much damage a full impact causes a robot
	float alpha;						// What alpha to draw this weapon with
	short sounds[MAX_WEAPON_SOUNDS];	// sounds for various things
	short hud_image_handle;				//  a handle to a bitmap or vclip for the hud display
	short fire_image_handle;				//  model or bitmap.  Shown when you fire this weapon
	short explode_image_handle;			//  exploding vclip
	short smoke_handle;						//  smoke trail handle to texture
	short spawn_handle;						// weapon handle that gets spawned
	short alternate_spawn_handle;		// weapon handle that gets spawned (sometimes)
	short robot_spawn_handle;			// robot that gets spawned as a countermeasure
	short particle_handle;					// particle handle to texture
	short icon_handle;
	short scorch_handle;					// handle for scorch bitmap, or -1 for none
	ubyte spawn_count;					// how many of spawn handle gets created
	ubyte alternate_chance;				// how often the alternate spawn weapon gets chosen (0 to 100)

	unsigned short used;
	
	ubyte particle_count;
	ubyte terrain_damage_depth;

	float terrain_damage_size;

	float scorch_size; 					// how big the scorch mark is
	
	int flags;							//  see above
	
	float size;
	float life_time;
	float thrust_time;
	float impact_size;
	float impact_time;
	float impact_player_damage,impact_generic_damage;
	float impact_force;
	float explode_size;
	float explode_time;
	float particle_size;
	float particle_life;
	float gravity_size;
	float gravity_time;
	float custom_size;
	float homing_fov;
	float recoil_force;

	light_info	lighting_info;
	physics_info phys_info;
	
} weapon;

typedef struct
{
	float total_time;

} fusion_effect;

//////////////////////////////////////////////////////////////////////////////
const ushort	WPNSEL_SKIP = 0x8000,
					WPNSEL_INVALID = 0xffff;


const ushort DefaultPrimarySelectList[MAX_PRIMARY_WEAPONS] = 
{
	LASER_INDEX,
	VAUSS_INDEX,
	MICROWAVE_INDEX,
	PLASMA_INDEX,
	FUSION_INDEX,
	SUPER_LASER_INDEX, 
	MASSDRIVER_INDEX,		 
	NAPALM_INDEX,		 
	EMD_INDEX,		 
	OMEGA_INDEX
};


const ushort DefaultSecondarySelectList[MAX_SECONDARY_WEAPONS] = 
{
	CONCUSSION_INDEX,
	HOMING_INDEX,			
	IMPACTMORTAR_INDEX,
	SMART_INDEX,
	MEGA_INDEX,
	FRAG_INDEX,
	GUIDED_INDEX+WPNSEL_SKIP,
	NAPALMROCKET_INDEX,
	CYCLONE_INDEX,
	BLACKSHARK_INDEX
};


#endif