/*
=========================================================
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE 
PROPERTY OF OUTRAGE ENTERTAINMENT, INC. 
('OUTRAGE').  OUTRAGE, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND 
CONDITIONS HEREIN, GRANTS A ROYALTY-FREE, 
PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY 
SUCH END-USERS IN USING, DISPLAYING,  AND 
CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-
COMMERCIAL, ROYALTY OR REVENUE FREE PURPOSES. 
IN NO EVENT SHALL THE END-USER USE THE 
COMPUTER CODE CONTAINED HEREIN FOR REVENUE-
BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE 
SAME BY USE OF THIS FILE.
COPYRIGHT 1999 OUTRAGE ENTERTAINMENT, INC.  ALL 
RIGHTS RESERVED.
=========================================================
*/

/*
 * Header for object.c
 *
 */

#ifndef _OBJECT_H
#define _OBJECT_H
#include "pstypes.h"
#include "object_external_struct.h"
#include "object_external.h"

/*
 *		CONSTANTS
 */

//Object handle stuff.  
//The handle is comprised of the object number in the low 10 bits, and a count in the high 22 bits.
#define HANDLE_OBJNUM_MASK			0x7ff			//to mask off the object number part of the handle
#define HANDLE_COUNT_MASK			0xfffff800	//to maks off the count part of the handle
#define HANDLE_COUNT_INCREMENT		0x800			//what gets added to the handle to increment it

// See object external for OBJ_ types

// Lighting render types
#define LRT_STATIC		0
#define LRT_GOURAUD		1
#define LRT_LIGHTMAPS	2


//stuctures for different kinds of weapon simulation (for precompution)

#define WPC_NOT_USED	     0
#define WPC_NO_COLLISIONS 1
#define WPC_HIT_WALL		  2


#define FMA_VALID	    1
#define FMA_CURRENT   2
#define FMA_LOOPING   4
#define FMA_USE_SPEED 8
#define FMA_HAS_AI	 16


#define FMT_NEW_DATA	1
#define FMT_UPDATING	2

//object light info flags
#define OLF_FLICKERING			1
#define OLF_TIMEBITS				2
#define OLF_PULSE					4
#define OLF_PULSE_TO_SECOND	8
#define OLF_FLICKER_SLIGHTLY	16		
#define OLF_DIRECTIONAL			32		// Directional light - casts light in a cone
#define OLF_NO_SPECULARITY		64		// Object does not have specular light cast on it

// OSIRIS defines
#define MAX_MODULENAME_LEN	32

//How long an object name can be
#define OBJ_NAME_LEN 19		//max length for object name

/*
 *		VARIABLES
 */


#define MAX_BIG_OBJECTS	350

//Compute the object number from an object pointer
#define OBJNUM(objp) (objp-Objects)
#define OBJHANDLE(objp) ((objp) ? (objp)->handle : 0)


#endif
