/*
=========================================================
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE 
PROPERTY OF OUTRAGE ENTERTAINMENT, INC. 
('OUTRAGE').  OUTRAGE, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND 
CONDITIONS HEREIN, GRANTS A ROYALTY-FREE, 
PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY 
SUCH END-USERS IN USING, DISPLAYING,  AND 
CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-
COMMERCIAL, ROYALTY OR REVENUE FREE PURPOSES. 
IN NO EVENT SHALL THE END-USER USE THE 
COMPUTER CODE CONTAINED HEREIN FOR REVENUE-
BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE 
SAME BY USE OF THIS FILE.
COPYRIGHT 1999 OUTRAGE ENTERTAINMENT, INC.  ALL 
RIGHTS RESERVED.
=========================================================
*/

#ifndef __DMFC_H__
#define __DMFC_H__

#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include "gamedll_header.h"
#include "DMFCKeyCodes.h"

#ifndef RELEASE

#ifdef WIN32
	#ifdef DEBUG_BREAK
		#undef DEBUG_BREAK
	#endif
	#define DEBUG_BREAK() \
		do { \
			if (DLLDebugBreak_callback_stop)  \
				DLLDebugBreak_callback_stop(); \
				_asm{ int 3}; \
			if (DebugBreak_callback_resume) \
				DebugBreak_callback_resume(); \
		} while(0)

	#define DLLASSERT(x) \
		do { \
			DLLassert(x,#x,__FILE__,__LINE__); \
		} while(0)
	#define DLLmprintf(args)	DLLDebug_ConsolePrintf args
	#ifdef ASSERT
		#undef ASSERT
	#endif
	#define ASSERT(x) \
		do { \
			DLLassert(x,#x,__FILE__,__LINE__); \
		} while(0)		
	
	#ifdef Int3
		#undef Int3
	#endif
	#define Int3() do { \
		mprintf((0, "Int3 at %s line %d.\n", __FILE__, __LINE__));	\
		if (DLLDebugBreak_callback_stop)  \
			DLLDebugBreak_callback_stop(); \
		_asm{ int 3}; \
		if (DLLDebugBreak_callback_resume) \
			DLLDebugBreak_callback_resume(); \
	} while (0)
#elif defined (__LINUX__)
	//For some reason Linux doesn't like the \ continuation character, so I have to uglify this
	#define DLLmprintf(args)	DLLDebug_ConsolePrintf args
	#ifdef DEBUG_BREAK
		#undef DEBUG_BREAK
	#endif
	#define DEBUG_BREAK() do{ if(DLLDebugBreak_callback_stop) DLLDebugBreak_callback_stop(); __asm__ __volatile__ ( "int $3" ); if(DLLDebugBreak_callback_resume) DLLDebugBreak_callback_resume(); }while(0)
	#ifdef ASSERT
		#undef ASSERT
	#endif
	#define ASSERT(x) do { DLLassert(x,#x,__FILE__,__LINE__); } while(0)
	#define DLLASSERT(x) ASSERT(x)
	#ifdef Int3
		#undef Int3
	#endif
	#define Int3() do{ mprintf((0, "Int3 at %s line %d.\n",__FILE__,__LINE__)); DEBUG_BREAK();}while(0)
	#define HEAPCHECK()
#elif defined (MACINTOSH)
	#ifdef DEBUG_BREAK
		#undef DEBUG_BREAK
	#endif
	#define DEBUG_BREAK() \
		do { \
			if (DLLDebugBreak_callback_stop)  \
				DLLDebugBreak_callback_stop(); \
				Debugger(); \
			if (DebugBreak_callback_resume) \
				DebugBreak_callback_resume(); \
		} while(0)

	#define DLLASSERT(x) \
		do { \
			DLLassert(x,#x,__FILE__,__LINE__); \
		} while(0)
	#define DLLmprintf(args)	DLLDebug_ConsolePrintf args
	#ifdef ASSERT
		#undef ASSERT
	#endif
	#define ASSERT(x) \
		do { \
			DLLassert(x,#x,__FILE__,__LINE__); \
		} while(0)		
	
	#ifdef Int3
		#undef Int3
	#endif
	#define Int3() do { \
		mprintf((0, "Int3 at %s line %d.\n", __FILE__, __LINE__));	\
		if (DLLDebugBreak_callback_stop)  \
			DLLDebugBreak_callback_stop(); \
/*		Debugger(); */\
		if (DLLDebugBreak_callback_resume) \
			DLLDebugBreak_callback_resume(); \
	} while (0)
#else
	#ifdef DEBUG_BREAK
		#undef DEBUG_BREAK
		#define DEBUG_BREAK()
	#endif
	#define DLLASSERT(x)
	#define DLLmprintf(args)
	#ifdef Int3
		#undef Int3
		#define Int3()
	#endif
	#define Int3()
	#ifdef ASSERT
		#undef ASSERT
		#define ASSERT(x)
	#endif
#endif//OS check

#else //Release build
	#ifdef DEBUG_BREAK
		#undef DEBUG_BREAK
		#define DEBUG_BREAK()
	#endif
	#define DLLASSERT(x)
	#define DLLmprintf(args)
	#ifdef Int3
		#undef Int3
		#define Int3()
	#endif
	#define Int3()
	#ifdef ASSERT
		#undef ASSERT
		#define ASSERT(x)
	#endif
#endif

#ifdef mprintf					//undefine mprintf and redirect it to use DLLmprintf
	#undef mprintf	
#endif
#define mprintf DLLmprintf

#define DLLMAX_PLAYERS	MAX_PLAYERS
#define DLLMAX_TEAMS	4
#define RED_TEAM	0
#define BLUE_TEAM	1
#define GREEN_TEAM	2
#define YELLOW_TEAM	3

#define GR_GREY	GR_RGB(128,128,128)
#define GR_GRAY GR_GREY

#define SP_ALL	-1
#define SP_SERVER -2
#define SPH_DMFCFUNC 0
#define SPH_FUNC 1

#define HI_TEXT		0
#define HI_BITMAP	1

#define MAX_TEAMNAME_LEN	16

// Defines for the window camera views
#define CV_NONE		0		//View not active
#define CV_REARVIEW	1		//Rear view
#define CV_MARKER1	2		//Marker view
#define CV_MARKER2	3		//Marker view
#define CV_MARKER3	4		//Marker view
#define CV_MARKER4	5		//Marker view
#define CV_MARKER5	6		//Marker view
#define CV_MARKER6	7		//Marker view
#define CV_MARKER7	8		//Last marker view
#define CV_MARKER8	9		//Last marker view
#define CV_GUIDEBOT	10		//Guide-Bot
#define NUM_CAMERA_VIEWS	3

///special characters in the fonts
#define CHAR_LEFT_ARROW			24
#define CHAR_UP_ARROW			25
#define CHAR_RIGHT_ARROW		26
#define CHAR_DOWN_ARROW			27
#define CHAR_CHECKBOX_OFF		28
#define CHAR_CHECKBOX_ON		29
#define CHAR_RADIO_OFF			30
#define CHAR_RADIO_ON			31

// The following defines are RGB definitions for colors that should be used throughout the UI for text
#define UICOL_HOTSPOT_LO		GR_RGB(85,234,3)		// Color for a hotspot when it isn't in focus//GR_RGB(50,50,255)		// Color for a hotspot when it isn't in focus
#define UICOL_HOTSPOT_HI		GR_RGB(207,248,105)		// Color for a hotspot when it is in focus
#define UICOL_TEXT_NORMAL		GR_RGB(206,254,241)		// Color for text that is used for labels
#define UICOL_WINDOW_TITLE		GR_RGB(207,248,105)		// Color for window title text
#define UICOL_TEXT_AUX			GR_RGB(200,200,200)		// Color for auxillary text (text that isn't a label)
#define UICOL_LISTBOX_LO		GR_RGB(85,234,3)			// Color for listbox text that isn't in focus
#define UICOL_LISTBOX_HI		GR_RGB(207,248,105)			// Color for listbox text that is in focus
#define UICOL_BUTTON_LO			GR_RGB(85,234,3)		// Color for text on a button that isn't in focus
#define UICOL_BUTTON_HI			GR_RGB(207,248,105)		// Color for text on a button that is in focus
#define UIALPHA_HOTSPOT_LO		192						// Alpha value for hotspots not in focus
#define UIALPHA_HOTSPOT_HI		255						// Alpha value for hotspots in focus
#define OKCANCEL_YOFFSET		50						//subtract this from the height of the window

// additional flags for creating a newui window
#define NUWF_TITLENONE		0x00000000	//don't display a title bar
#define NUWF_TITLESMALL		0x00100000	//display a small title bar
#define NUWF_TITLEMED		0x00200000	//display a medium size title bar
#define NUWF_TITLELARGE		0x00300000	//display a large title bar
#define NUWF_TITLEBARMASK	0x00300000	//mask to use with flags to get title bar flags

// predefined return values for DLLDoUI/DLLPollUI...exit the dialog immediatly!!
#define NEWUIRES_FORCEQUIT					-2	
#define UID_OK					0xEE
#define UID_CANCEL				0xEF


#define MAX_MENUNAME		32
#define MF_SERVER			0x0001
#define MF_CLIENT			0x0002
#define MF_ALL				0x0003

#define REGT_STRING	0
#define REGT_DWORD	1
#define CFG_NOERROR		0	//There was no error
#define CFG_ALREADYOPEN	1	//The registry/cfg is already open
#define CFG_OUTOFMEMORY 2	//Out of memory
#define CFG_NOCFGFILE	3	//You didn't give a config file name
#define CFG_NOTOPEN		4	//You haven't opened the config file yet
#define CFG_KEYNOTFOUND	5	//The key you're looking up hasn't been created or isn't in the registry
#define CFG_RECORDNOTFOUND	6 //The record you're lookup up isn't in the active key
#define CFG_CANTCREATE	7	//There was an error trying to create a record

#define MIT_NORMAL		0	//Allowed to have submenus
#define MIT_PLIST			1	//A Player List
#define MIT_STATE			2	//Radio Button like submenu list
#define MIT_STATEITEM	3	//Given to the submenu list items of the above
#define MIT_CUSTOM		4	//use this along with filled in tCustomMenu* (as the only parm in the variable parms section
							// of MenuItem constructor to create a user defined menu list

#define MAX_STRING_LEN		32	//Maximum string length for a menu title
#define MAX_DMFC_TIMERS	16
#define MAX_DEATH_MSGS	32

#define MAX_CALLSIGN_SIZE	25
#define MAX_PLAYER_RECORDS	64
#define DSTAT_LEVEL			0
#define DSTAT_OVERALL		1

#define MAX_DBNAME_SIZE		32
#define MAX_DBLABEL_SIZE	128

typedef struct{
	int (*GetListCount)(void);	//this function should return the number of items in the list
	char *(*GetItem)(int index);	//this function should return a string of the item at the given index, NULL on error
}tCustomMenu;

typedef struct
{
	int slot;	//player record slot
	int kills;	//number of times you killed this player
	int deaths;	//number of times this player killed you
}tPInfoStat;

typedef enum {STATE_EMPTY,STATE_INGAME,STATE_DISCONNECTED} slot_state;

typedef struct{
	int kills[2],deaths[2],suicides[2];
}t_dstat;

typedef struct{
	slot_state		state;							//state of this slot
	char			callsign[MAX_CALLSIGN_SIZE];	//Player's callsign
	char			*tracker_id;					//Player's master tracker ID, NULL if there isn't one
	network_address	net_addr;						//Player's address
	int				pnum;							//Player's pnum
	union{
		float			disconnect_time;				//Time player disconnected
		float			start_time;						//Time the player entered the game
	};
	float			total_time_in_game;				//Total time the player has been in the game
	t_dstat			dstats;							//DMFC's stats	
	void			*user_info;						//Multiplayer Mod user defined struct pointer
	int				user_info_size;					//Size of user_info;

	sbyte			team;							//The player's team (for when they reconnect)
	void			*pinfo;							//Pointer to player info (who killed whom)
}player_record;

#define MIF_INCLUDENONE		0x01	//for MIT_PSTATE, this will place a <None> at the top, it will send a -1 to the function, if selected
//#define MIF_IGNORESERVER	0x02	//for MIT_PSTATE, this will keep the server out of the list
//#define MIF_IGNOREME		0x04	//for MIT_PSTATE, this will keep your pnum out of the list


#define MAX_COLUMN_TITLE_SIZE	15

typedef enum{
	DSCOL_KILLS_LEVEL,DSCOL_KILLS_OVERALL,DSCOL_KILLS_BOTH,
	DSCOL_DEATHS_LEVEL,DSCOL_DEATHS_OVERALL,DSCOL_DEATHS_BOTH,
	DSCOL_SUICIDES_LEVEL,DSCOL_SUICIDES_OVERALL,DSCOL_SUICIDES_BOTH,
	DSCOL_PILOT_NAME,DSCOL_PILOT_TEAM,DSCOL_PING,DSCOL_CUSTOM,DSCOL_BLANK,
	DSCOL_BMP
}tColumnType;

typedef enum{
	DSCOLOR_NORMAL,DSCOLOR_TEAM,DSCOLOR_SHIPCOLOR,DSCOLOR_CUSTOM
}tColorType;

typedef struct{
	//what type of information should be displayed in this column, use custom if you want
	//the callback to fill in your own data
	tColumnType type;
	//what type of color to use
	tColorType color_type;
	//title for column
	char title[MAX_COLUMN_TITLE_SIZE];
	//width of the column (note: columns will not be rendered if the total width of the 
	//columns exceeds the width of the display)
	int width;
	//color of the text for this column (if color type is custom)
	ddgr_color color;
}tDmfcStatsColumnInfo;

//=====================================================================
//tDmfcStatsInit flags
#define DSIF_SEPERATE_BY_TEAM	0x00000001	//this tells the stats manager to seperate the players by 
											//team (useful only in a team game).  By default it will 
											//list all the players in a straight list
#define DSIF_SHOW_PIC			0x00000002	//The pilot's picture (if available else logo if available) should 
											//be shown in the detailed section
#define DSIF_ONLY_X_PLAYERS_SHOWN 0x000004	//If set, than the MaxNumberDisplayed member of tDmfcStatsInit
											//must also be valid (throughout the lifetime of the stats
											//being displayed).  The stat manager will only display
											// (*MaxNumberDisplayed) stats (checked each frame).
#define DSIF_SHOW_OBSERVERICON	0x00000008	//if this flag is given, the observer mode icon will be
											//displayed as the first item in the column
#define DSIF_NOLASTKILLER		0x00000010	//don't display the "Last Killer"
#define DSIF_NOLASTVICTIM		0x00000020	//don't display the "Last Victim"
#define DSIF_NODETAILEDINFO		0x00000040	//don't display the detailed stats
#define DSIF_SHOWPLAYERVIEW		0x00000080	//display the current view of the selected player (only available if DSIF_NODETAILEDINFO is also set)

//=====================================================================
typedef struct{
	//see the DSIF_* for the list of available flags and descriptions
	int flags;
	//points to an array of player record numbers, sorted to however you want them sorted.  Each
	//frame this array will be used when displaying the stats.
	int *SortedPlayerRecords;
	//the number of columns you want printed in the player list column for each player
	int cColumnCountPlayerList;
	//the number of columns you want printed in the detailed player info
	int cColumnCountDetailed;
	//Informtaion for the player list columns (array of tDmfcStatsColumnInfo structs)
	tDmfcStatsColumnInfo *PlayerListColumns;
	//Information for the detailed columns (array of tDmfcStatsColumnInfo structs)
	tDmfcStatsColumnInfo *DetailedColumns;
	//Callback function when the stats manager needs to get information when displaying a playerlist column
	//	precord_num:	contains the player record number of the player it needs information about
	//	column_num:		which column (index into the PlayerListColumns array) it is working on
	//	buffer:			buffer to fill in for your data
	//	buffer_size:	number of bytes you can use for your data (IT MUST BE NULL TERMINATED STRING)
	void (*clbPlayerColumn)(int precord_num,int column_num,char *buffer,int buffer_size);
	//Callback function when the stats manager needs to get information when displaying a detailed column
	//	precord_num:	contains the player record number of the player it needs information about
	//	column_num:		which column (index into the DetailedColumns array) it is working on
	//	buffer:			buffer to fill in for your data
	//	buffer_size:	number of bytes you can use for your data (IT MUST BE NULL TERMINATED STRING)
	void (*clbDetailedColumn)(int precord_num,int column_num,char *buffer,int buffer_size);
	//Callback function when the stats manager needs to draw the custom bitmap on the playerlist column
	//	precord_num:	contains the player record number of the player it displaying
	//	column_num:		which column (index into the PlayerListColumns array) it is working on
	//	x,y,w,h:		the (x,y) position of the upper left corner of the area, and the allowed width/height
	//handle the drawing in this function
	void (*clbPlayerColumnBMP)(int precord_num,int column_num,int x,int y,int w,int h,ubyte alpha_to_use);
	//Callback function when the stats manager needs to draw the custom bitmap on the detailed column
	//	precord_num:	contains the player record number of the player it displaying
	//	column_num:		which column (index into the DetailedColumns array) it is working on
	//	x,y,w,h:		the (x,y) position of the upper left corner of the area, and the allowed width/height
	//handle the drawing in this function
	void (*clbDetailedColumnBMP)(int precord_num,int column_num,int x,int y,int w,int h,ubyte alpha_to_use);
	//Callback function when the stats manager needs to display team info for a particular team
	//	team:			contains the team it's displaying about (0 = red, ... 3 = yellow)
	//	buffer:			buffer to fill in for your data
	//	buffer_size:	number of bytes you can use for your data (IT MUST BE NULL TERMINATED STRING)
	void (*clTeamLine)(int team,char *buffer,int buffer_size);
	//Points to a buffer that contains the name of the multiplayer game (NULL TERMINATED STRING)
	char *GameName;
	//if the DSIF_ONLY_X_PLAYERS_SHOWN flag is set, than the stat manager checks this value (dereferenced) every frame and will only show this many players
	int *MaxNumberDisplayed;
}tDmfcStatsInit;

#endif