/*
=========================================================
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE 
PROPERTY OF OUTRAGE ENTERTAINMENT, INC. 
('OUTRAGE').  OUTRAGE, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND 
CONDITIONS HEREIN, GRANTS A ROYALTY-FREE, 
PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY 
SUCH END-USERS IN USING, DISPLAYING,  AND 
CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-
COMMERCIAL, ROYALTY OR REVENUE FREE PURPOSES. 
IN NO EVENT SHALL THE END-USER USE THE 
COMPUTER CODE CONTAINED HEREIN FOR REVENUE-
BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE 
SAME BY USE OF THIS FILE.
COPYRIGHT 1999 OUTRAGE ENTERTAINMENT, INC.  ALL 
RIGHTS RESERVED.
=========================================================
*/

/*
 *
 * Functions for reading & writing files.  Includes code to read from libraries.
 *
 */

#ifndef CFILE_H
#define CFILE_H

#include <stdio.h>

//The structure for a CFILE
typedef struct CFILE {
	char	*name;				//pointer to filename
	FILE 	*file;				//the file itself (on disk) or the HOG
	int	lib_handle;			//the handle of the library, or -1
	int	size;					//length of this file
	int	lib_offset;			//offset into HOG of start of file, or 0 if on disk
	int	position;			//current position in file
	int	flags;				//see values below
} CFILE;

//Defines for cfile_error
#define CFE_READING		1
#define CFE_WRITING		2

//The structure thrown by a cfile error
typedef struct {
	int	read_write;		//reading or writing?  See defines.
	char	*msg;				//the error message
	CFILE	*file;			//the file that got the error
} cfile_error;

//Flags for CFILE struct
#define CF_TEXT		1		//if this bit set, file is text
#define CF_WRITING	2		//if bit set, file opened for writing

//return values for cfexist()
#define CF_NOT_FOUND		0
#define CF_ON_DISK		1
#define CF_IN_LIBRARY	2

#endif
