/*
=========================================================
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE 
PROPERTY OF OUTRAGE ENTERTAINMENT, INC. 
('OUTRAGE').  OUTRAGE, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND 
CONDITIONS HEREIN, GRANTS A ROYALTY-FREE, 
PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY 
SUCH END-USERS IN USING, DISPLAYING,  AND 
CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-
COMMERCIAL, ROYALTY OR REVENUE FREE PURPOSES. 
IN NO EVENT SHALL THE END-USER USE THE 
COMPUTER CODE CONTAINED HEREIN FOR REVENUE-
BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE 
SAME BY USE OF THIS FILE.
COPYRIGHT 1999 OUTRAGE ENTERTAINMENT, INC.  ALL 
RIGHTS RESERVED.
=========================================================
*/

/*
 *
 * Header for renderer library
 */

#ifndef RENDERER_H
#define RENDERER_H

#include "pstypes.h"
#include "grdefs.h"

//Declare this here so we don't need to include 3d.h
typedef struct g3Point g3Point;
typedef struct chunked_bitmap chunked_bitmap;

#define TEXTURE_WIDTH	128
#define TEXTURE_HEIGHT	128
#define TEXTURE_BPP		2

#define FLAT_SHADE_COLOR	0x7C01
// If an incoming texture has the above color in it, change that color to this color
#define REPLACEMENT_COLOR	0x07C0

// Is this hardware or software rendered?
typedef enum
{
	RENDERER_SOFTWARE_8BIT,
	RENDERER_SOFTWARE_16BIT,
	RENDERER_OPENGL,
	RENDERER_DIRECT3D,
	RENDERER_GLIDE,
	RENDERER_NONE,
} renderer_type;

// renderer clear flags
#define RF_CLEAR_ZBUFFER	1
#define RF_CLEAR_COLOR		2

// Overlay texture settings
#define OT_NONE			0			// No overlay
#define OT_BLEND			1			// Draw a lightmap texture afterwards
#define OT_REPLACE		2			// Draw a tmap2 style texture afterwards
#define OT_FLAT_BLEND	3			// Draw a gouraud shaded polygon afterwards
#define OT_BLEND_VERTEX	4			// Like OT_BLEND, but take constant alpha into account
#define OT_BUMPMAP		5			// Draw a saturated bumpmap afterwards
#define OT_BLEND_SATURATE	6		// Add a lightmap in

// various state setting functions
//------------------------------------

#define MAP_TYPE_BITMAP			0
#define MAP_TYPE_LIGHTMAP		1
#define MAP_TYPE_BUMPMAP		2
#define MAP_TYPE_UNKNOWN		3

// lighting state
typedef enum
{
	LS_NONE,				// no lighting, fully lit rendering
	LS_GOURAUD,			// Gouraud shading
	LS_PHONG,			// Phong shading
	LS_FLAT_GOURAUD	 // Take color from flat color
} light_state;


typedef enum
{
	CM_MONO,		// monochromatic (intensity) model - default
	CM_RGB,			// RGB model
} color_model;


typedef enum
{
	TT_FLAT,					// solid color
	TT_LINEAR,					// textured linearly
	TT_PERSPECTIVE,				// texture perspectively
	TT_LINEAR_SPECIAL,			// A textured polygon drawn as a flat color
	TT_PERSPECTIVE_SPECIAL,			// A textured polygon drawn as a flat color
} texture_type;

// Alpha type flags - used to decide what type of alpha blending to use
#define ATF_CONSTANT		1		// Take constant alpha into account
#define ATF_TEXTURE		2		// Take texture alpha into account
#define ATF_VERTEX		4		// Take vertex alpha into account

// Alpha types
#define	AT_ALWAYS				0				// Alpha is always 255 (1.0)					
#define	AT_CONSTANT				1				// constant alpha across the whole image
#define	AT_TEXTURE				2				// Only uses texture alpha
#define	AT_CONSTANT_TEXTURE  3				// Use texture * constant alpha
#define	AT_VERTEX				4				// Use vertex alpha only
#define	AT_CONSTANT_VERTEX	5				// Use vertex * constant alpha
#define	AT_TEXTURE_VERTEX		6				// Use texture * vertex alpha
#define	AT_CONSTANT_TEXTURE_VERTEX	7		// Use all three (texture constant vertex)
#define	AT_LIGHTMAP_BLEND		8				// dest*src colors
#define  AT_SATURATE_TEXTURE	9				// Saturate up to white when blending
#define  AT_FLAT_BLEND			10				// Like lightmap blend, but uses gouraud shaded flat polygon
#define  AT_ANTIALIAS			11				// Draws an antialiased polygon
#define  AT_SATURATE_VERTEX	12				// Saturation with vertices
#define  AT_SATURATE_CONSTANT_VERTEX	13  // Constant*vertex saturation
#define	AT_SATURATE_TEXTURE_VERTEX		14	// Texture * vertex saturation
#define	AT_LIGHTMAP_BLEND_VERTEX		15	//	Like AT_LIGHTMAP_BLEND, but take vertex alpha into account
#define	AT_LIGHTMAP_BLEND_CONSTANT		16	// Like AT_LIGHTMAP_BLEND, but take constant alpha into account
#define	AT_SPECULAR							32	
#define	AT_LIGHTMAP_BLEND_SATURATE		33	// Light lightmap blend, but add instead of multiply

#define	LFB_LOCK_READ		0
#define	LFB_LOCK_WRITE		1

typedef enum
{
	WT_WRAP,			// Texture repeats
	WT_CLAMP,		// Texture clamps
	WT_WRAP_V		// Texture wraps in v
} wrap_type;

typedef struct
{
	sbyte initted;			

	sbyte cur_bilinear_state;
	sbyte cur_zbuffer_state;
	sbyte cur_fog_state;
	sbyte cur_mip_state;

	texture_type cur_texture_type;
	color_model	cur_color_model;
	light_state cur_light_state;
	sbyte			cur_alpha_type;

	wrap_type	cur_wrap_type;

	float cur_fog_start,cur_fog_end;
	float cur_near_z,cur_far_z;
	float gamma_value;

	int			cur_alpha;
	ddgr_color	cur_color;
	ddgr_color	cur_fog_color;
	
	sbyte cur_texture_quality;		// 0-none, 1-linear, 2-perspective

	int clip_x1,clip_x2,clip_y1,clip_y2;
	int screen_width,screen_height;

}	rendering_state;

typedef struct
{
	ubyte mipping;
	ubyte filtering;
	float gamma;
	ubyte bit_depth;
	int width,height;
	ubyte vsync_on;
} renderer_preferred_state;

typedef struct 
{
	int type;
	ushort *data;
	int bytes_per_row;
} renderer_lfb;

#endif
