/*
=========================================================
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE 
PROPERTY OF OUTRAGE ENTERTAINMENT, INC. 
('OUTRAGE').  OUTRAGE, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND 
CONDITIONS HEREIN, GRANTS A ROYALTY-FREE, 
PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY 
SUCH END-USERS IN USING, DISPLAYING,  AND 
CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-
COMMERCIAL, ROYALTY OR REVENUE FREE PURPOSES. 
IN NO EVENT SHALL THE END-USER USE THE 
COMPUTER CODE CONTAINED HEREIN FOR REVENUE-
BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE 
SAME BY USE OF THIS FILE.
COPYRIGHT 1999 OUTRAGE ENTERTAINMENT, INC.  ALL 
RIGHTS RESERVED.
=========================================================
*/

/*
*
* Find intersection header
*
*
* $NoKeywords: $
*/

#ifndef _FVI_H
#define _FVI_H

#include "vecmat_external.h"
#include "pstypes.h"
#include "findintersection_external.h"


#define CEILING_HEIGHT	(Ceiling_height)

#define PLAYER_SIZE_SCALAR 0.8f

// Big Object Info
#define CELLS_PER_COL_CELL		1
#define COL_TERRAIN_SIZE		(TERRAIN_SIZE*(float)CELLS_PER_COL_CELL)

#define MIN_BIG_OBJ_RAD	(COL_TERRAIN_SIZE)

// chrishack -- we could turn backface, on and off so that we
// can individually use backface checking on object and/or wall...  :)

#define MAX_FVI_SEGS 100

#define MAX_HITS	2

#define Q_RIGHT	0
#define Q_LEFT		1
#define Q_MIDDLE  2

inline bool FastVectorBBox(const float *min, const float *max, const float *origin, const float *dir)
{
	bool f_inside = true;
	char quad[3];
	register int i;
	float max_t[3];
	float can_plane[3];
	int which_plane;
	float coord[3];

	for(i = 0; i < 3; i++)
	{
		if(origin[i] < min[i])
		{
			quad[i] = Q_LEFT;
			can_plane[i] = min[i];
			f_inside = false;
		}
		else if (origin[i] > max[i])
		{
			quad[i] = Q_RIGHT;
			can_plane[i] = max[i];
			f_inside = false;
		}
		else
		{
			quad[i] = Q_MIDDLE;
		}
	}

	if(f_inside)
	{
		return true;
	}

	for(i = 0; i < 3; i++)
	{
		if(quad[i] != Q_MIDDLE && dir[i] != 0.0f)
			max_t[i] = (can_plane[i] - origin[i])/dir[i];	
		else
			max_t[i] = -1.0f;
	}

	which_plane = 0;

	for(i = 0; i < 3; i++)
		if(max_t[which_plane] < max_t[i])
			which_plane = i;

	if(max_t[which_plane] < 0.0f)
		return false;

	for(i = 0; i < 3; i++)
	{
		if (which_plane != i)
		{
			coord[i] = origin[i] + max_t[which_plane] * dir[i];

			if((quad[i] == Q_RIGHT && coord[i] < min[i]) ||
				(quad[i] == Q_LEFT && coord[i] > max[i]))
			{
				return false;
			}
		}
		else
		{
			coord[i] = can_plane[i];
		}
	}

	return true;
}

//this data structure gets filled in by find_vector_intersection()
typedef struct fvi_info 
{
	vector hit_pnt;						// centerpoint when we hit
	int hit_room;							// what room hit_pnt is in
	float hit_dist;						// distance of the hit
	
	int num_hits;							// Number of recorded hits

	int hit_type[MAX_HITS]; 			//what sort of intersection
	vector hit_face_pnt[MAX_HITS];	// actual collision point (edge of rad)
	
	int hit_face_room[MAX_HITS];		// what room the hit face is in
	int hit_face[MAX_HITS];				// if hit wall, which face
	vector hit_wallnorm[MAX_HITS];	// if hit wall, ptr to its surface normal

	int hit_object[MAX_HITS];			// if object hit, which object
	int hit_subobject[MAX_HITS];		// if a POLY_2_SPHERE hit, then it has the poly involved

	int n_rooms;							// how many segs we went through
	int roomlist[MAX_FVI_SEGS];		// list of segs vector went through

	// BBox hit results
	matrix hit_orient;
	vector hit_rotvel;
	angle  hit_turnroll;
	vector hit_velocity;
	float  hit_time;

	vector hit_subobj_fvec;
	vector hit_subobj_uvec;
	vector hit_subobj_pos;
} fvi_info;

//this data contains the parms to fvi()
typedef struct fvi_query 
{
	vector *p0,*p1;
	int startroom;
	float rad;
	short thisobjnum;
	int *ignore_obj_list;
	int flags;

	// BBox stuff...
	matrix *o_orient;
	vector *o_rotvel;
	vector *o_rotthrust;
	vector *o_velocity;
	angle *o_turnroll;
	vector *o_thrust;
	float frametime;
} fvi_query;

// Face/Room list for some fvi call(s)
typedef struct fvi_face_room_list
{
	ushort face_index;
	ushort room_index;
} fvi_face_room_list;

#define MAX_RECORDED_FACES 200


#endif

