/*
=========================================================
THE COMPUTER CODE CONTAINED HEREIN IS THE SOLE 
PROPERTY OF OUTRAGE ENTERTAINMENT, INC. 
('OUTRAGE').  OUTRAGE, IN DISTRIBUTING THE CODE TO
END-USERS, AND SUBJECT TO ALL OF THE TERMS AND 
CONDITIONS HEREIN, GRANTS A ROYALTY-FREE, 
PERPETUAL LICENSE TO SUCH END-USERS FOR USE BY 
SUCH END-USERS IN USING, DISPLAYING,  AND 
CREATING DERIVATIVE WORKS THEREOF, SO LONG AS
SUCH USE, DISPLAY OR CREATION IS FOR NON-
COMMERCIAL, ROYALTY OR REVENUE FREE PURPOSES. 
IN NO EVENT SHALL THE END-USER USE THE 
COMPUTER CODE CONTAINED HEREIN FOR REVENUE-
BEARING PURPOSES.  THE END-USER UNDERSTANDS
AND AGREES TO THE TERMS HEREIN AND ACCEPTS THE 
SAME BY USE OF THIS FILE.
COPYRIGHT 1999 OUTRAGE ENTERTAINMENT, INC.  ALL 
RIGHTS RESERVED.
=========================================================
*/

/*
 * Header file for Descent 3 3d library
 */

#ifndef _3D_H
#define _3D_H

#include "pstypes.h"
#include "vecmat_external.h"		//the vector/matrix library
#include <float.h>

//Structure for storing u,v,light values.  This structure doesn't have a
//prefix because it was defined somewhere else before it was moved here
typedef struct g3UVL {
	float	u,v;			//texture coordinates
	float u2,v2;
	
	union{
		float	l;				//intensity lighting
		float   r;
	};
	float g,b,a;		//rgba lighting
} g3UVL;

//Stucture to store clipping codes in a word
typedef struct g3Codes {
	ubyte cc_or,cc_and;
} g3Codes;

//flags for point structure
#define PF_PROJECTED 	1	//has been projected, so sx,sy valid
#define PF_FAR_ALPHA		2	//past fog zone
#define PF_TEMP_POINT	4	//created during clip
#define PF_UV				8	//has uv values set
#define PF_L				16	//has lighting values set
#define PF_RGBA			32	//has RGBA lighting values set
#define PF_UV2				64 // has lightmap uvs as well


//clipping codes flags

#define CC_OFF_LEFT	1
#define CC_OFF_RIGHT	2
#define CC_OFF_BOT	4
#define CC_OFF_TOP	8
#define CC_OFF_FAR	16
#define CC_OFF_CUSTOM	32
#define CC_BEHIND		128

//Used to store rotated points for mines.  Has frame count to indictate
//if rotated, and flag to indicate if projected.
typedef struct g3Point {
	float		p3_sx,p3_sy;		//screen x&y
	ubyte		p3_codes;			//clipping codes
	ubyte		p3_flags;			//projected?
	short		p3_pad;				//keep structure longword aligned
	vector		p3_vec;				//x,y,z of rotated point
	g3UVL		p3_uvl;				//uv & lighting values
} g3Point;

//macros to reference x,y,z elements of a 3d point
#define p3_x p3_vec.x
#define p3_y p3_vec.y
#define p3_z p3_vec.z

//macros to reference individual elements of the uvls struct
#define p3_u p3_uvl.u
#define p3_v p3_uvl.v
#define p3_l p3_uvl.l
#define p3_r p3_uvl.r
#define p3_g p3_uvl.g
#define p3_b p3_uvl.b
#define p3_a p3_uvl.a
#define p3_u2 p3_uvl.u2
#define p3_v2 p3_uvl.v2


#endif

