/*************************************************************************/
/* sdk-tool 0.01 beta (March 2007) - A Descent tool written in C         */
/* Copyright (C) 2007 Philipp Lorenz (E-Mail: descent1@gmx.net)          */
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or (at */
/* your option) any later version.                                       */
/* This program is distributed in the hope that it will be useful, but   */
/* WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      */
/* General Public License for more details.                              */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA  */
/*************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

int m;
FILE *einlesen;
FILE *gccv;
FILE *update;
char *updatestr;
char vernum[]="0.01_beta";
char *dallas;
char *dallas_buffer;
char *added_mods;
char *gccversion;
char slashsrc[6]="/src/";
char slashbin[5]="/bin";
char filename[]="directory.txt";
char modfilename[]="mods.txt";
char a, b, x, y, z;
int mirror;
char *package;
char *mycwd;
FILE *einlesen;
char *added_mods;
FILE *directory;
FILE *mods;
char *sdk_path;
char *new_mod;
char *moddir;
char *modname;

int main(void)
{
moddir = (char*) malloc(256);
modname = (char*) malloc(256);
sdk_path = (char*) malloc(256);
new_mod = (char*) malloc(128);
added_mods = (char*) malloc(256);
package = (char*) malloc(5);
dallas = (char*) malloc(128);
dallas_buffer = (char*) malloc(128);
updatestr = (char*) malloc(64);
mycwd = getcwd(NULL, 512);

if( (einlesen = fopen("mods.txt", "r")) == NULL)
{
 printf("Failed to open mods.txt! Does it exist? If not, create an empty file mods.txt.\n");
 exit(0);
}

fread(added_mods, sizeof(char), 256, einlesen);
fclose(einlesen);

if( (directory = fopen("directory.txt", "r")) == NULL)
{
 printf("Failed to open directory.txt Maybe this is your first start?\n");
 sleep(3);
 system("clear");
}
else
{
fread(sdk_path, sizeof(char), 256, directory);
fclose(directory);
}

if(strstr(sdk_path,"\n")!=NULL) 
 strcpy(strstr(sdk_path,"\n"),"\0");

while(1)
{
	printf("Do you have SDK and gcc-2.8.1 already installed? You need gcc-2.8.1 to compile these mods! \n(at your first start, you should type n) (y/n) ");
	scanf("%c",&a);
	while(getchar()!='\n');

	if(a == 'y')
		break;

	printf("This will install the Descent3 Support Development Kit on Linux. Do you wish to continue? (y/n) ");

	scanf("%c", &x);
	while(getchar()!='\n');

	if( x != 'y' )
		exit(0);

	printf("Do you want to download from mirror 1 or 2? [1/2] "); 
	scanf("%d",&mirror);
	while(getchar()!='\n');

	if (mirror == 1)
		system("wget -O /tmp/d3sdk.tar.gz http://dcent.110mb.com/downloads/d3-sdk_v14.tar.gz");
	else if (mirror == 2)
		system("wget -O /tmp/d3sdk.tar.gz http://intelcentino.in.funpic.de/Downloads/d3-sdk_v14.tar.gz");
	else 
		exit(1);

	if ( (directory = fopen(filename, "w")) == NULL)
	{
		fprintf(stderr, "Failed to create directory.txt! Shutting down!");
		exit(1);
	}

	printf("Where do you want to install the D3SDK? ");
	scanf("%s",sdk_path);
	while(getchar()!='\n');
	fprintf(directory, "%s", sdk_path);
	fclose(directory);
	system("bash create.sh");

	printf("To compile some mods for Descent3, you need gcc-2.8.1. I think, you can get it just from my site. Do you want to download and install this package? This will downgrade gcc and remove g++! (y/n) ");
	scanf("%c",&y);
	fflush(stdin);
	if (y != 'y')
	 break;
	
	do {printf("Are you running a rpm- or a deb-package-management? (r/d) ");
	while(getchar()!='\n');
	scanf("%c",&z);
	while(getchar()!='\n');
	}while (z!='r'&&z!='d');

	if(z == 'r')
	{
		system("wget -O /tmp/gcc-2.8.1-2.i386.rpm http://dcent.110mb.com/downloads/gcc-2.8.1-2.i386.rpm");
		system("sudo rpm --nodeps -e gcc");
		system("sudo rpm --nodeps --Uvh /tmp/gcc-2.8.1-2.i386.rpm");
	}

	if(z == 'd')
	{
		system("wget -O /tmp/gcc_2.8.1-1_i386.deb.gz http://dcent.110mb.com/downloads/gcc_2.8.1-1_i386.deb.gz");
		system("gunzip /tmp/gcc_2.8.1-1_i386.deb.gz");
		system("sudo apt-get remove g++");
		system("sudo dpkg -i /tmp/gcc_2.8.1-1_i386.deb");
	}

	printf("gcc-2.8.1 was successfully installed!\n");
	sleep(2);
	break;
}

while (1)
{

switch(menu())
	{
		case 1:
		{
		printf("\n\nAvailable Mods: \n\nanarchy\nanarchy-c (unfinished Anarchy)\nentropy");
		printf("\n%s", added_mods);
		printf("\n\nDid you add a new mod? You have to put it in %s/src/yourmod (y/n) ",sdk_path);
		while(getchar()!='\n');
		scanf("%c",&b);
		while(getchar()!='\n');
		if(b != 'y')
			continue;
		
		if ( (mods = fopen(modfilename, "a")) == NULL)
		{
		 fprintf(stderr, "Failed to create mods.txt! Shutting down!");
		 exit(1);
		}		

		printf("What is the name of the mod you added? ");
		scanf("%s",new_mod);
		while(getchar()!='\n');
		fprintf(mods, "%s\n", new_mod);
		fclose(mods);
		continue;
		}	

		case 2:
		{
		if( strncmp(gccversion,"2.8.1",5) )
		{
			printf("You are not running gcc-2.8.1! Because this won't work, you'll be redirected to the menu now.\n");
			while(getchar()!='\n');
			printf("Press ENTER to continue... ");
			getc(stdin);
			continue;
		}
		printf("What's the name of your mod? ");
		scanf("%s",modname);
		strcpy(moddir, sdk_path);
		strcat(moddir, slashsrc);
		strcat(moddir, modname);
		printf("%s\n", moddir);
		chdir(moddir); /* go into source-directory */
		printf("Starting compiling...\n");
		sleep(1);
		system("make");
		printf("Done.\n");
		sleep(2);
		chdir(mycwd); /* go back to the directory before (like in bash "cd -") */		
		continue;
		}

		case 3:
		{
		printf("Wait for version 0.02! Sorry!  \n\n\n");
		sleep(2);
		continue;
		}

		case 4:
		{
		printf("Please put the cpp-file into yoursdkpath/bin and press ENTER...");
		while(getchar()!='\n');
		fflush(stdin);
		fflush(stdout);
		getc(stdin);
				
		if( strncmp(gccversion,"2.8.1",5) )
		{
			printf("You are not running gcc-2.8.1! Because this won't work, you'll be redirected to the menu now.\n");
			printf("Press ENTER to continue... ");
			getc(stdin);
			continue;
		}
		
		strcpy(dallas_buffer, sdk_path);
		strcat(dallas_buffer, slashbin);
		chdir(dallas_buffer); /* go into bin-directory */
		system("bash compile.sh");
		chdir(mycwd); /* go back to the directory before (like in bash "cd -") */
		printf("Your script was compiled.\nPress ENTER to continue... ");
		while(getchar()!='\n');
		continue;
		}

                case 5:
		{
		printf("Getting update-list. Please wait...");
		while(getchar()!='\n');
		fflush(stdout);
		fflush(stdin);
		system("wget -O /tmp/update.txt	http://intelcentino.in.funpic.de/sdk-update/update.txt >/dev/null 2>/dev/null");
		chdir("/tmp");
		if( (update = fopen("update.txt", "r")) == NULL)
		{
	 	 printf("\nFailed to open /tmp/update.txt. Maybe downloading failed?\n");
		 exit(1);
		}
		else
		{
		 fread(updatestr, sizeof(char), 64, update);
		 fclose(update);
		}
		
		if(strstr(updatestr,"\n")!=NULL) 
		 strcpy(strstr(updatestr,"\n"),"\0");

		remove("/tmp/update.txt");

		if( ! strncmp(updatestr,vernum,12) )
		{
		 printf("\nCould not find any updates. \n");
		 sleep(2);
		 chdir(mycwd);
		 while(getchar()!='\n');
		 fflush(stdout);
		 fflush(stdin);
		 continue;
		}
		
		printf("\nFound update!\n");
		printf("Updating");
		sleep(1);
		chdir(mycwd);
		printf(".");
		system("wget http://intelcentino.in.funpic.de/sdk-update/sdkupdate.tar.gz 2>/dev/null >/dev/null");
		printf(".");
		system("tar xvfz sdkupdate.tar.gz 2>/dev/null >/dev/null");
		remove("sdkupdate.tar.gz");
		printf(". done\n");
		sleep(1);
		continue;
		}
		
		case 6:
                {
		system("clear");
                while(getchar()!='\n');
		puts("SDK-TOOL v0.01\n==============\n");
		puts("By: Philipp Lorenz aka DIIIA-D.Cent");
		puts("Version: 0.01");
		puts("Release: beta");
		puts("Some information: If you get any warnings: Ignore them!\n\n");
		
		printf("License: GPL2\n\nPress ENTER to continue... ");
		getc(stdin);
		system("clear");
		continue;
                }

		case 7:
		{
		printf("Shutting down...\n");
		exit(0);
		}

		default:
		{
		puts("Wrong number! Try again.");
		sleep(2);
		continue;	
		}
	}
}

return 0;

}

int menu(int choice)
{

added_mods = (char*) malloc(256);

if( (einlesen = fopen("mods.txt", "r")) == NULL)
{
printf("Failed to open mods.txt! Aborting...\n");
exit(1); 
}

fread(added_mods, sizeof(char), 256, einlesen);

fclose(einlesen);

system("bash gcc-version.sh");

gccversion = (char*) malloc(10);

if( (gccv = fopen("version.txt", "r")) == NULL)
{
printf("Failed to open version.txt! Did you remove gcc-version.sh? Aborting...\n");
exit(1); 
}

fread(gccversion, sizeof(char), 10, gccv);

fclose(gccv);

system("clear");
puts("MENU");
puts("====\n");
puts("1. Show available sourcecodes");
puts("2. Compile mod...");
puts("3. Install new source...");
puts("4. Compile dallas script...");
puts("5. Update sdk-tool...");
puts("6. Help");
puts("7. Quit\n");
printf("YOUR CHOICE: ");
scanf("%d",&choice);
return choice;
}
